 /*-----------------------------------------------------------------------------*
 * File Name: XFunction.h			 											*
 * Creation: CPY 2/6/2006														*
 * Purpose: OriginC Source C file												*
 * Copyright (c)Originlab Corp.	2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 3/6/2006 AUTOUPDATE_MORE_WORK											*
 *	ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING					*
 *	ML 7/19/2006 REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE			*
 *	Joseph 11/08/06 ADD_VARIABLE_VALUE											*
 * Justin 03/11/07 v8.0578 DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION *
 *	CPY 5/8/2007 QA70-9566 OUTPUT_TO_RESULTS_LOG_CHECKBOX_IN_GETN				*
 *	Joseph 06/06/07 MOVE_SOME_FUNCTIONS_AND_DEFINITIONS_TO_XFUNCTION_HEADER_FILE*
 *  SY 2007-06-06 QA70-9426 v8.0634 ASSIGN_TREE_VARABILE_FOR_XF_IN_LT			*
 *	Hong 08/28/07 QA80-10310 MORE_VARIABLE_INFO_FOR_XF2GUI						*
 *	CPY 11/20/07 FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION						*
 *	CPY 12/1/2007 QA70-10765 DEFAULT_CODE_PAGE_CONTROL							*
 *	CPY 12/5/07 QA70-10782 REPORT_FOR_J_SHOW_JUNK								*
 *	Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING			*
 *	YuI 10/01/08 QA70-12321 LOAD_AND_COMPILE_XF_AND_NOTHING_MORE				*
 *	Folger 01/09/09 v8.0995 CHANGE_PARAM_SHOULD_DO_EVALUATE_EXACTLY_THE_SAME_AS_NORMAL_EXECUTE
 *	Folger 03/10/09 QA80-11855 LT_XF_HELP_DUMPING_NEEDS_SUPPORT_DISPLAY_RELATED_XF
 *	Folger 08/05/10 ORG-702-P1 CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
 *------------------------------------------------------------------------------*/

#ifndef _X_FUNCTION_H_
#define _X_FUNCTION_H_

#include <XFbase.h> 

#define _XF_LT_CALL_IN_VC //CPY 1/27/06


/// YuI 04/11/05 XFOPERATION_CHANGE_PARAM
enum
{
	OPSETXFUNCTION_NOT_MODIFIED,
	OPSETXFUNCTION_SET_MODIFIED,
	OPSETXFUNCTION_EXECUTE,
};

enum {
	INDEX_OF_NON_REPORT_TREE_VARS_IN_OUTPUT_ARRAY,
	REPORT_TREE_VARS_IN_OUTPUT_ARRAY_BEGIN,
};

/// Justin 2007-03-11 v8.0578 DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION
int _get_current_language();
/// End DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION

///Joseph 06/06/07 MOVE_SOME_FUNCTIONS_AND_DEFINITIONS_TO_XFUNCTION_HEADER_FILE
#define STR_LANGUAGE_ENGLISH				"English"
#define STR_LANGUAGE_JAPANESE				"Japanese"
#define STR_LANGUAGE_GERMAN					"German"
#define STR_LANGUAGE_CHINESE				"Chinese"

enum 
{
	LANG_ALL = 0,
	LANG_ENGLISH,
	LANG_JAPANESE,
	LANG_GERMAN,
	LANG_CHINESE
};
///End MOVE_SOME_FUNCTIONS_AND_DEFINITIONS_TO_XFUNCTION_HEADER_FILE

//------ Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING
enum
{
	XF_HELP_LIST_ALL = 1,
	XF_HELP_LIST_USAGE,
	XF_HELP_LIST_VARIABLES,
	XF_HELP_LIST_TREENODE_DETAILS,
	/// YuI 10/01/08 QA70-12321 LOAD_AND_COMPILE_XF_AND_NOTHING_MORE
	XF_HELP_LIST_NONE,
	/// end LOAD_AND_COMPILE_XF_AND_NOTHING_MORE
	XF_HELP_LIST_RELATED_XF,		///------ Folger 03/10/09 QA80-11855 LT_XF_HELP_DUMPING_NEEDS_SUPPORT_DISPLAY_RELATED_XF
};
//------

class XFunction : public XFBase
{
public:
	//----- CPY 12/1/2007 QA70-10765 DEFAULT_CODE_PAGE_CONTROL
	/*
	XFunction()
	{
		//m_bInternal = false;
	}
	XFunction(TreeNode& trXF, bool bInternal, BOOL bCompile = false, BOOL bPrepareVars = true) : XFBase(trXF, bCompile, bPrepareVars, bInternal)
	{
		//m_bInternal = bInternal;
		m_tree = trXF;
	}
	~XFunction() {}
	*/
	XFunction();
	XFunction(TreeNode& trXF, bool bInternal, BOOL bCompile = false, BOOL bPrepareVars = true);
	~XFunction();
private:
	//---- CPY 12/5/07 QA70-10782 REPORT_FOR_J_SHOW_JUNK
	//int m_nSaveXMLStrCodePage;
	//----
	//----- end DEFAULT_CODE_PAGE_CONTROL
	
public:
	TreeNode GetTree() {return m_tree;}
	//bool IsInternal() { return m_bInternal; }
	
	/// ML 7/19/2006 REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
	//bool Load(TreeNode* ptrXF, LPCSTR lpcszOxfName, DWORD dwCntrl = 0, bool bCreateVars = true, bool bSkipHelps = false, bool bCompile = false)
	//{			
	//	//bool bOK = XFBase::Load(lpcszOxfName, dwCntrl, m_tree, false, bSkipHelps);
	//	bool bOK = XFBase::Load(lpcszOxfName, dwCntrl, m_tree, bCompile, bSkipHelps, bCreateVars);
	//	if(bOK)
	//	{
	//		if(ptrXF)
	//			*ptrXF = m_tree;
	//	}
	//	return bOK;
	//}
	bool Load(TreeNode* ptrXF, LPCSTR lpcszOxfName, DWORD dwCntrl = 0, bool bCreateVars = true, bool bSkipHelps = false, bool bCompile = false, const TreeNode& trGetN = NULL)
	{			
		//bool bOK = XFBase::Load(lpcszOxfName, dwCntrl, m_tree, false, bSkipHelps);
		bool bOK = XFBase::Load(lpcszOxfName, dwCntrl, m_tree, bCompile, bSkipHelps, bCreateVars, trGetN);
		if(bOK)
		{
			if(ptrXF)
				*ptrXF = m_tree;
		}
		return bOK;
	}
	//---------- CPY 11/20/07 FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION
	// load without doing any localization, which happens by default for GUI access
	bool LoadNoLocalize(TreeNode* ptrXF, LPCSTR lpcszOxfName, DWORD dwCntrl = 0, bool bCreateVars = true, bool bSkipHelps = false, bool bCompile = false)
	{
		double dVal;
		LT_get_var("@PDS", &dVal);
		LT_set_var("@PDS", 0);
		bool bOK = Load(ptrXF, lpcszOxfName, dwCntrl, bCreateVars, bSkipHelps, bCompile);
		LT_set_var("@PDS", dVal);
		return bOK;
	}
	//---------- end FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION

	/// end REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
	//------ Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING
	//string GetHelpInfo(bool bComplete = true, int nLanguage = IDRS_HELP_E);
	//BOOL DisplayHelp()
	string GetHelpInfo(bool bComplete = true, int nLanguage = IDRS_HELP_E, int nHelpList = XF_HELP_LIST_ALL);
	BOOL DisplayHelp(int nHelpList = XF_HELP_LIST_ALL)
	//------
	{
		/// YuI 10/01/08 QA70-12321 LOAD_AND_COMPILE_XF_AND_NOTHING_MORE
		if( XF_HELP_LIST_NONE == nHelpList )
			return TRUE;
		/// end LOAD_AND_COMPILE_XF_AND_NOTHING_MORE

		/// Justin 2007-03-11 v8.0578 DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION
		//string str = GetHelpInfo();
		//------ Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING
		//string str = GetHelpInfo(true, _get_current_language());
		string str = GetHelpInfo(true, _get_current_language(), nHelpList);
		//------
		/// End DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION
		
		out_str(str);
		
		if(str.IsEmpty())
			return false;
		
		return TRUE;
	}
	string	GetFunctionName(bool bConvertToCname = false)
	{
		return okutil_xft_get_function_name(&m_tree, bConvertToCname, IsInternal());
	}
	TreeNode GetHelp(int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E) 
	{
		return xf_get_help_node(m_tree, nNodeID, nLanguage); 
	}
	bool UpdateEditables()
	{
		return okutil_xft_update_editables(&m_tree, IsInternal(), &m_vpEditables);
	}
	TreeNode GetVariableTreeNode(LPCSTR lpcszVar)
	{
		return xf_get_variable_tree_node(m_tree, lpcszVar);
	}
	bool  GetSourcePath(string& strFullPath, bool bPrepareFile = false)
	{
		return okutil_xft_get_source_path(&m_tree, &strFullPath, bPrepareFile, IsInternal(), &m_vpEditables);
	}
	void GetReturnType(string& strType)
	{
		okutil_xft_get_var_return_type(&m_tree, &strType);
	}

	vector<point>&  GetEditables()
	{
		return m_vpEditables;
	}

	string GetVarsInfo(DWORD dwDisplayOptions, int nLanguage = IDRS_HELP_E);
	string GetHelpBriefInfo();
	/// Hong 08/28/07 QA80-10310 MORE_VARIABLE_INFO_FOR_XF2GUI
	//string GetHelpText(int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E, bool bUseEwhenEmpty = true);
	string GetHelpText(int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E, bool bUseEwhenEmpty = false);
	/// end MORE_VARIABLE_INFO_FOR_XF2GUI
	string GetKeywordSearchText(string * p_strDisplayStr=NULL);
	bool UpdateInternalOperation(uint uidOp, uint nCntrl = OPSETXFUNCTION_SET_MODIFIED);

	/// Hong 08/28/07 QA80-10310 MORE_VARIABLE_INFO_FOR_XF2GUI
	TreeNode GetVarHelp(LPCSTR lpcszVar, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E) 
	{
		TreeNode trVar = GetVariableTreeNode(lpcszVar);
		//return xf_get_help_node(trVar, nNodeID, nLanguage); // this code only support help level, should fix to support variable level too
		TreeNode trNode;
		octree_find_node_by_dataID(&trNode, &trVar, nNodeID, IDV_VAR_LOCAL_HELP_BRANCH, nLanguage);
		return trNode;
	}
	
	string GetVarHelpText(LPCSTR lpcszVar, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E, bool bUseEwhenEmpty = false); 
	
	bool SetHelpText(LPCSTR lpcszVal, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E);
	
	bool SetVarHelpText(LPCSTR lpcszVar, LPCSTR lpcszVal, int nNodeID = IDV_HELP_SUMMARY, int nLanguage = IDRS_HELP_E); 
	/// end MORE_VARIABLE_INFO_FOR_XF2GUI
	
	/// Justin 2007-03-11 v8.0578 DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION
	//string GetVarsHelpInfo();
	/// SY 2007-06-06 QA70-9426 v8.0634 ASSIGN_TREE_VARABILE_FOR_XF_IN_LT
	///	string GetVarsHelpInfo(int nLanguage = IDRS_HELP_E);
	//------ Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING
	//string GetVarsHelpInfo(int nLanguage = IDRS_HELP_E, BOOL bComplete = FALSE);
	string GetVarsHelpInfo(int nLanguage = IDRS_HELP_E, BOOL bComplete = FALSE, int nHelpList = XF_HELP_LIST_ALL);
	//------
	/// end ASSIGN_TREE_VARABILE_FOR_XF_IN_LT
	///End DISPLAY_DIFF_LANGUAGE_HELP_FOR_DIFF_LANGUAGE_VERSION
	
	bool GetSourceBookSheet(string &strBookName, string &strSheetName)	//--- Frank 4/8/05 GET_BOOK_SHEET_NAME_OF_XVAR_CLASS
	{
		return false;
	}
	bool	ExecuteMenuCheck(int& nCheck) {return false;}

	///Joseph 11/08/06 ADD_VARIABLE_VALUE
	//string GetSuggestedValue(int nVar)
	//{
		//string str;
		//return str;
	//}
	//string GetComboString(int nVar)
	//{
		//string str;
		//return str;
	//}
	
	string GetSuggestedValue(string strVar)
	{
		TreeNode tr = GetVariableTreeNode(strVar);
		return tr.suggestedValues.strVal;
	}
	/// AW 02/15/07 QA80-9378 v8.0564 SUPPORT_ENUM_FOR_ARGU_FROM_LT
	/*
	string GetComboString(string strVar)
	{
		TreeNode tr = GetVariableTreeNode(strVar);

		return tr.comboString.strVal;
	}
	*/
	/// END SUPPORT_ENUM_FOR_ARGU_FROM_LT
	///End ADD_VARIABLE_VALUE
	void OnChangeVarData(TreeNode& trVar) { }

	// The same as the constructor with four arguments:
	BOOL Create(TreeNode& trXF, bool bInternal, BOOL bCompile = false, BOOL bPrepareVars = true)
	{
		m_tree = trXF;
		//m_bInternal = bInternal;
		//parseTree(m_tree);
		return Init(trXF, bCompile, bPrepareVars, bInternal);
	}
	//BOOL UpdateFromOperationRanges(DataRange *pdrInput, Array<DataRange&>* parrOutputs);
	
	/// ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING
	//BOOL	Evaluate(DataRange *pdrInput, Array<DataRange&>* parrOutputs, DWORD dwCtrl = LTXF_FROM_AUTO_UPDATE | LTXF_EXECUTE | LTXF_OUT_RESULTS_LOG);
	//	BOOL	Evaluate(DataRange *pdrInput, Array<DataRange&>* parrOutputs, DWORD dwCtrl = LTXF_FROM_AUTO_UPDATE | LTXF_EXECUTE | LTXF_OUT_RESULTS_LOG, vector<uint> *pvMapIdsToUIDs = NULL);
	///------ Folger 01/09/09 v8.0995 CHANGE_PARAM_SHOULD_DO_EVALUATE_EXACTLY_THE_SAME_AS_NORMAL_EXECUTE
	//BOOL	Evaluate(DataRange *pdrInput, Array<DataRange&>* parrOutputs, DWORD dwCtrl = LTXF_FROM_AUTO_UPDATE | LTXF_EXECUTE, vector<uint> *pvMapIdsToUIDs = NULL, TreeNode* pGetN = NULL);
	///------ Folger 08/05/10 ORG-702-P1 CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
	//BOOL	Evaluate(DataRange *pdrInput, Array<DataRange&>* parrOutputs, DWORD dwCtrl = LTXF_FROM_AUTO_UPDATE | LTXF_EXECUTE, vector<uint> *pvMapIdsToUIDs = NULL, TreeNode* pGetN = NULL, double rXFVersionLastTime = DEFAULT_XFVERSION_LAST_TIME_RUN);
	BOOL	Evaluate(DataRange *pdrInput, Array<DataRange&>* parrOutputs, DWORD dwCtrl = LTXF_FROM_AUTO_UPDATE | LTXF_EXECUTE, vector<uint> *pvMapIdsToUIDs = NULL, TreeNode* pGetN = NULL, double rXFVersionLastTime = DEFAULT_XFVERSION_LAST_TIME_RUN, OUID nOpUID = 0);
	///------ End CLEAR_OUTPUT_DATA_WITHOUT_ERROR_FOR_XF_OPERATION_RECALCULATE_IF_INPUT_IS_EMPTY
	///------ End CHANGE_PARAM_SHOULD_DO_EVALUATE_EXACTLY_THE_SAME_AS_NORMAL_EXECUTE
	/// end REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING

	//--------- CPY 7/12/06 QA70-8731 AUTO_UPDATE_LOST_FROM_GUI
	/// ML 3/6/2006 AUTOUPDATE_MORE_WORK
	//BOOL	Run(BOOL bAutoUpdate, TreeNode& trGetN = NULL);
	/// end AUTOUPDATE_MORE_WORK
	//bool CreateInternalOperation(bool bExecute = true, uint* pOpUID = NULL, bool bAutoUpdate = true);
	BOOL	Run(int nAutoUpdate, TreeNode& trGetN = NULL);
	/// ML 7/19/2006 REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
	//BOOL	CreateInternalOperation(BOOL bAutoUpdate = false, DWORD dwCntrl = LTXF_EXECUTE | LTXF_OUT_RESULTS_LOG, uint* pOpUID = NULL);
	// trGetN is input.
	BOOL	CreateInternalOperation(BOOL bAutoUpdate = false, DWORD dwCntrl = LTXF_EXECUTE, uint* pOpUID = NULL, TreeNode& trGetN = NULL);
	/// end REMEMBERING_SETTINGS_IN_XFOPERATION_FOR_AUTO_UPDATE
	//--------

private:
/*
	void	parseTree(TreeNode& tr)
	{
		if( !tr.IsValid() )
			return;
		
		TreeNode trVars = tr.vars;
		if( !trVars )
			return;
		foreach( TreeNode trVar in trVars.Children )
		{
			XVariableBase* pXVar = CreateXVariable(trVar);
			m_arrXVar.Add(*pXVar);
		}
	}
*/

	//------ Folger 07/16/08 QA80-11855 BETTER_FORMATTING_FOR_XF_HELP_DUMPING
	string		getHelpUsageInfo(int nLanguage);
	string		getHelpVariablesInfo(int nLanguage, BOOL bComplete, int nHelpList);
	string		getHelpTreeNodeDetailsInfo();
	//------ End BETTER_FORMATTING_FOR_XF_HELP_DUMPING
	
	string		getRelatedXFInfo(int nLanguage);		///------ Folger 03/10/09 QA80-11855 LT_XF_HELP_DUMPING_NEEDS_SUPPORT_DISPLAY_RELATED_XF

private:
	TreeNode				m_tree;
	//bool					m_bInternal;
	vector<point>			m_vpEditables;
};

//----- CPY 11/03/07 FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION
class 	XFVARPDS
{
public:
	XFVARPDS() {
		LT_get_var("@PDS", &m_dOldVal);
		LT_set_var("@PDS", 0);
	}
	~XFVARPDS() {
		LT_set_var("@PDS", m_dOldVal);
	}
private:
	double m_dOldVal;
};
//----- end FORCE_LOAD_XF_WIHTOUT_VALDATA_LOCALIZATION



#endif //_X_FUNCTION_H_